<?php 
/*** Redux Framework ***/
require_once get_template_directory().'/admin/init.php';

/*** Theme Framework ***/
require_once get_template_directory().'/framework/init.php';	

// Add Instalment Widget below the product price using ACF
add_action('woocommerce_single_product_summary', 'add_instalment_widget_acf', 25);

function add_instalment_widget_acf() {
    $acf_price = get_field('product_price');
    if ($acf_price): ?>
        <div id="instalmentCalc"
             data-amount="<?php echo esc_attr($acf_price); ?>"
             data-before="Credit Amount:"
             data-after="per month"
             data-textColor="#666"
             data-bgColor="transparent"
             data-padding="0"
             data-margin="5"
             data-fontFamily="inherit"
             data-fontSize="16"
             data-fontWeight="normal">
        </div>
    <?php endif;
}